using System;
using System.Collections.Generic;
using System.Net;
using System.Linq;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.VBECS.VistaLinkServer.Core
{
	/// <summary>
	/// Class VistALinkRpcManager
	/// </summary>
	public class VistALinkRpcManager : RpcManager
	{
	    ///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/30/2010</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9082"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9083"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ExecuteRpcRequest
		/// </summary>
		/// <param name="request"></param>
		/// <param name="clientIp"></param>
		/// <returns></returns>
		public string ExecuteRpcRequest( RpcRequest request, IPAddress clientIp, List<PublishedProcedure> procedures )
		{
			if( request == null )
				throw( new ArgumentNullException( "request" ) );

			if( clientIp == null )
				throw( new ArgumentNullException( "clientIp" ) );

            if (procedures == null)
                throw (new ArgumentNullException("procedures"));

	        PublishedProcedure procedulre = procedures.SingleOrDefault(i => i.Name == request.RpcName);

            if (procedulre == null)
                throw( new PublishedProcedureNotFoundException( "Published procedure '{0}' was not found in the list of published procedures." ) );


			object baseResult = 
				ExecutePublishedProcedure(
                procedulre, 
				new CallerSecurityEvidence( request.RpcSecurityContext, clientIp ),
				request.Parameters.GetParametersValues() );

			return baseResult != null ? baseResult.ToString() : null;
		}
	}
}
